//
//  MailAlertBundle.m
//  MailAlert
//
//  Created by Jan-Peter Krämer on 23.10.09.
//  Copyright 2009 RWTH Aachen University. All rights reserved.
//

#import "MailAlertBundle.h"

#import "MessageViewer.h"

#import <objc/runtime.h>

@interface MailAlertBundle ()

-(void)showAlert:(NSNotification *)notification ;

@end


@implementation MailAlertBundle

+ (void) initialize;
{
	NSLog(@"Mail Alert initialize called");
	[super initialize];
	
	Class mvMailBundleClass = NSClassFromString(@"MVMailBundle");
	if(!mvMailBundleClass){
		NSLog(@"Mail.app does not have a MVMailBundle class available");
		return; 
	}

	class_setSuperclass([self class], mvMailBundleClass);
	[self registerBundle];
}

- (id) init
{
	NSLog(@"init called");
	self = [super init];
	if (self != nil) {
		[[NSNotificationCenter defaultCenter] addObserver:self 
												 selector:@selector(showAlert:)
													 name:NSApplicationDidBecomeActiveNotification
												   object:nil];
	}
	return self;
}

-(void)showAlert:(NSNotification *)notification ;
{
	[[NSNotificationCenter defaultCenter] removeObserver:self];
//	[[NSAlert alertWithMessageText:@"Hello World!" 
//					 defaultButton:@"Dismiss" 
//				   alternateButton:nil 
//					   otherButton:nil 
//		 informativeTextWithFormat:@"We suceessfully created our first Mail.app plugin!"] runModal];	

	Class messageViewerClass = NSClassFromString(@"MessageViewer");
	
	MessageViewer *messageViewer = [[[messageViewerClass alloc] init] autorelease];
	[messageViewer showComposeWindow:self]; 
	
}


@end
